Attribute VB_Name = "modDatabase"
Option Explicit

Public Const ATTR_B As Long = &H1
Public Const ATTR_C As Long = &H2
Public Const ATTR_D As Long = &H4
Public Const ATTR_J As Long = &H8
Public Const ATTR_M As Long = &H10
Public Const ATTR_O As Long = &H20
Public Const ATTR_S As Long = &H40
Public Const ATTR_X As Long = &H80

Public Function AttributeToString(ByRef Attr As Long) As String
    Dim buf As String
    If (Attr And ATTR_B) = ATTR_B Then buf = buf & "B"
    If (Attr And ATTR_C) = ATTR_C Then buf = buf & "C"
    If (Attr And ATTR_D) = ATTR_D Then buf = buf & "D"
    If (Attr And ATTR_J) = ATTR_J Then buf = buf & "J"
    If (Attr And ATTR_M) = ATTR_M Then buf = buf & "M"
    If (Attr And ATTR_O) = ATTR_O Then buf = buf & "O"
    If (Attr And ATTR_S) = ATTR_S Then buf = buf & "S"
    If (Attr And ATTR_X) = ATTR_X Then buf = buf & "X"
    AttributeToString = buf
End Function

Public Function ParseAttribute(ByRef Attr As Long) As Long
    ParseAttribute = StringToAttribute(AttributeToString(Attr))
End Function

Public Function ParseAttributeString(ByRef Attr As String) As String
    ParseAttributeString = AttributeToString(StringToAttribute(Attr))
End Function

Public Function StringToAttribute(ByRef Attr As String) As Long
    Dim buf As Long
    Attr = UCase$(Attr)
    If (InStrB(Attr, "B") > 0) Then buf = buf Or ATTR_B
    If (InStrB(Attr, "C") > 0) Then buf = buf Or ATTR_C
    If (InStrB(Attr, "D") > 0) Then buf = buf Or ATTR_D
    If (InStrB(Attr, "J") > 0) Then buf = buf Or ATTR_J
    If (InStrB(Attr, "M") > 0) Then buf = buf Or ATTR_M
    If (InStrB(Attr, "O") > 0) Then buf = buf Or ATTR_O
    If (InStrB(Attr, "S") > 0) Then buf = buf Or ATTR_S
    If (InStrB(Attr, "X") > 0) Then buf = buf Or ATTR_X
    StringToAttribute = buf
End Function
    

'B - basic commands
'     say
'     ver
'C - clan management
'     invite
'     ddp
'     remove
'     setmotd
'     setpeon
'     setgrunt
'     setshaman
'     setchieftain
'     accept
'     decline
'D - db management
'     add
'     remove
'     update
'J - join
'     resign
'     rejoin
'     join
'     home
'M - moderation
'     ban
'     kick
'     designate
'O - owner
'     quit
'     setusername
'     setpassword
'     setcdkey
'     setcdkeyex
'     setclient
'     sethome
'S - safe
'     cannot be banned
'     will be unbanned if banned
'X - banned
'     always banned
